IF EXISTS ( SELECT * FROM INFORMATION_SCHEMA.TABLES
				WHERE
					TABLE_NAME ='V_PDV_VD_CUPONS_COMPARACAO')
BEGIN
	DROP VIEW  [DBO].[V_PDV_VD_CUPONS_COMPARACAO] 
END
GO
--SELECT * FROM V_PDV_VD_CUPONS_COMPARACAO WHERE CD_EMP =1 AND CD_FILIAL = 2 AND DT_VD = '2018-06-21' ORDER BY CD_CX,NR_ECF
CREATE VIEW V_PDV_VD_CUPONS_COMPARACAO AS
	SELECT
		   C.CD_EMP,
		   C.CD_FILIAL,
		   C.NR_ECF,
		   C.CD_CX,
		   C.DT_VD,
		   C.VLR_LIQ_VD AS VLR_LIQ_VD_LOJA,
		   V.VLR_LIQ_VD AS VLR_LIQ_VD_MTZ,
		   C.VLR_LIQ_VD - ISNULL(V.VLR_LIQ_VD,0) AS VLR_DIF ,
		   CASE WHEN C.ST_VD =1 THEN
		   	'CANCELADO'
		   ELSE
		   	''
		   END AS ST_VD_LOJA,
		   CASE WHEN V.ST_VD =1 THEN
		   	'CANCELADO'
		   ELSE
		   	''
		   END AS ST_VD_MTZ,
		   CASE WHEN C.ST_VD <> ISNULL(V.ST_VD,-1) THEN
		   	'SIM'
		   ELSE
		   	''
		   END AS ST_VD_DIF,
		   C.DT_CAD,
		   V.DT_CONSD,
		   ISNULL(V.CD_VD,0) AS CD_VD,
		   CONVERT(CHAR(10),V.DT_VD,120) + ' ' + CONVERT(CHAR(5),ISNULL(V.HR_VD,''),114)COLLATE  SQL_LATIN1_GENERAL_CP1_CI_AS  DT_VD_HORA_VENDA,
		   C.ST_VD AS ST_VD,
		   'CUPOM FISCAL' AS DS_TIPO_OPERACAO,
		   0 AS TIPO_OPERACAO,
		   ISNULL(P.CD_CTR,0) AS CONSD_PEND,
		   ISNULL(E.CD_CONTROLE,0) AS ERRO,
		   ISNULL(E.LAUDO,'') COLLATE  SQL_LATIN1_GENERAL_CP1_CI_AS AS LAUDO  ,
		   '' AS CD_CTR_NCC,
		   C.NR_ECF_UUID  COLLATE  SQL_LATIN1_GENERAL_CP1_CI_AS AS NR_ECF_UUID
	FROM PDV_VD_CUPONS C 
		 LEFT OUTER JOIN PDV_VD V ON C.CD_EMP    = V.CD_EMP 
								 AND C.CD_FILIAL = V.CD_FILIAL 
								 AND C.NR_ECF    = V.NR_ECF 
								 AND C.CD_CX     = V.CD_CX 
								 AND C.CD_VD     = V.CD_VD                      -- FOI ADICIONADO PARA EVITAR QUE VENDAS COM O MESMO NR_ECF SEJAM CONFUNDIDAS
		/* C.DT_VD = V.DT_VD */
	    LEFT OUTER JOIN PDV_CONSLD_VD_CUPOM_PENDENCIA P ON C.CD_EMP    = P.CD_EMP 
													   AND C.CD_FILIAL = P.CD_FILIAL 
													   AND C.NR_ECF    = P.NR_ECF 
													   AND C.CD_CX     = P.CD_CX 
													   AND /* C.DT_VD = P.DT_VD AND */ C.TP_CUPOM = P.TP_CUPOM
		LEFT OUTER JOIN ADM_ERRO_PDV_VD_INTEGRACOES E ON C.CD_EMP    = E.CD_EMP 
													 AND C.CD_FILIAL = E.CD_FILIAL 
													 AND C.NR_ECF    = E.NR_ECF 
													 AND C.CD_CX     = E.CD_CX 
													 AND /* C.DT_VD = E.DT_VD AND */ C.TP_CUPOM = E.TP_CUPOM		
	WHERE C.TP_CUPOM = 0
	  AND E.DT_CAD =   ( SELECT MAX(DT_CAD) 
					       FROM ADM_ERRO_PDV_VD_INTEGRACOES I
						  WHERE E.CD_EMP    = I.CD_EMP
							AND E.CD_FILIAL = I.CD_FILIAL
							AND E.NR_ECF    = I.NR_ECF
							AND E.CD_CX     = I.CD_CX
							AND E.TP_CUPOM  = I.TP_CUPOM
							)
	UNION ALL
	SELECT
		   C.CD_EMP,
		   C.CD_FILIAL,
		   C.NR_ECF,
		   C.CD_CX,
		   C.DT_VD,
		   V.VLR_LIQ_VD AS VLR_LIQ_VD_LOJA,
		   C.VLR_LIQ_VD AS VLR_LIQ_VD_MTZ,
		   V.VLR_LIQ_VD - ISNULL(C.VLR_LIQ_VD,0) AS VLR_DIF ,
		   CASE WHEN V.ST_VD =1 THEN
		   	'CANCELADO'
		   ELSE
		   	''
		   END AS ST_VD_LOJA,
		   CASE WHEN C.ST_VD =1 THEN
		   	'CANCELADO'
		   ELSE
		   	''
		   END AS ST_VD_MTZ,
		   CASE WHEN C.ST_VD <> ISNULL(V.ST_VD,-1) THEN
		   	'SIM'
		   ELSE
		   	''
		   END AS ST_VD_DIF,
		   C.DT_CAD,
		   C.DT_CONSD,
		   ISNULL(C.CD_VD,0) AS CD_VD,
		   CONVERT(CHAR(10),C.DT_VD,120) + ' ' + CONVERT(CHAR(5),ISNULL(C.HR_VD,''),114) COLLATE  SQL_LATIN1_GENERAL_CP1_CI_AS DT_VD_HORA_VENDA,
		   C.ST_VD AS ST_VD,
		   'CUPOM FISCAL' AS DS_TIPO_OPERACAO,
		   0 AS TIPO_OPERACAO,
		   ISNULL(P.CD_CTR,0) AS CONSD_PEND,
		   ISNULL(E.CD_CONTROLE,0) AS ERRO,
		   ISNULL(E.LAUDO,'') COLLATE  SQL_LATIN1_GENERAL_CP1_CI_AS AS LAUDO,
		   '' AS CD_CTR_NCC,
		   C.NR_ECF_UUID COLLATE  SQL_LATIN1_GENERAL_CP1_CI_AS AS NR_ECF_UUID
	FROM
		PDV_VD C LEFT OUTER JOIN  PDV_VD_CUPONS V ON
		C.CD_EMP = V.CD_EMP AND
		C.CD_FILIAL = V.CD_FILIAL AND
		C.NR_ECF = V.NR_ECF AND
		C.CD_CX = V.CD_CX AND 
		C.CD_VD=V.CD_VD         -- FOI ADICIONADO PARA EVITAR QUE VENDAS COM O MESMO NR_ECF SEJAM CONFUNDIDAS
		/* C.DT_VD = V.DT_VD */
	    LEFT OUTER JOIN PDV_CONSLD_VD_CUPOM_PENDENCIA P ON
		C.CD_EMP = P.CD_EMP AND
		C.CD_FILIAL = P.CD_FILIAL AND
		C.NR_ECF = P.NR_ECF AND
		C.CD_CX = P.CD_CX AND
		/* C.DT_VD = P.DT_VD AND */
		0 = P.TP_CUPOM
		LEFT OUTER JOIN ADM_ERRO_PDV_VD_INTEGRACOES E ON
		C.CD_EMP = E.CD_EMP AND
		C.CD_FILIAL = E.CD_FILIAL AND
		C.NR_ECF = E.NR_ECF AND
		C.CD_CX = E.CD_CX AND
		/* C.DT_VD = E.DT_VD AND */
		0 = E.TP_CUPOM		
	WHERE
		V.NR_ECF IS NULL
		AND E.DT_CAD =   (SELECT MAX(DT_CAD) 
					        FROM ADM_ERRO_PDV_VD_INTEGRACOES I
						   WHERE E.CD_EMP    = I.CD_EMP
							 AND E.CD_FILIAL = I.CD_FILIAL
							 AND E.NR_ECF    = I.NR_ECF
							 AND E.CD_CX     = I.CD_CX
							 AND E.TP_CUPOM  = I.TP_CUPOM
							)